# coding: iso-8859-1

# Classe faisant le lien entre l'IHM et le rest des fonctions de l'application
class Controleur
  

  def initialize
  
    @memoire = []


  end


  # Point central du contrleur, toutes les actions passent par l
  def executer(commande, *params)


    # On vide le fichier d'erreurs
    Affichage::error_empty


    # On mmorise la commande
    memoriser(commande, *params)

    # On envoie la requte su serveur
    Thread.new{
      txt = ""
      for par in params
        txt += par.to_s+" "
      end
      txt.strip!
      #p txt

      news = News::send_news_4_9(commande.to_s, $dmk_version, txt)
    }
    # On l'excute
    send(commande, *params)


    # On affiche les ventuelles erreurs
    Affichage::error_total

  end


  # Mets en mmoire les actions effectues
  def memoriser(*params)

    @memoire << params

    #p @memoire
  end




  # ETAPE 1
  #
  # Dcompile les maps et BD du projet.
  # Par dfaut, toutes celles du projet.
  def dmk_convert_to_dmk(toutes=true)


    #toutes = false
    $project.nettoyer


    $project.decompiler(toutes)

    #puts "infos programme :"
    #puts "nombre d'appels a trouve_nombre : ", @@count_tn
    #puts "nombre d'appels a to_128 : ", @@count_128
    #puts "nombre d'appels a compacter_instruction : ", @@count_inst
    #puts "nombre d'appels divers : ", @@count_div

  end



  # ETAPE 2
  #
  # Extrait les dialogues des fichiers DMK
  #
  def dmk_dialogs_extraction




    $project.extraire_texte_first



  end


  # ETAPE 3
  # Inclut les dialogues dans les fichiers DMK
  #
  #
  def dmk_dialogs_inclusion(toutes=true)



    begin
      $project.etape_3
    rescue DMKW_DMK_Bad_Version => e
      Affichage::warning(e.message)
      raise(DMKW_Cancel.new)
    end


    #bool = Interface::dialogue_maj

    #return if bool != true

    DA::file_copy(F_DIAL, F_DIAL_SAVE)
    

    dmk_dialogs_extraction

    Affichage::info("#37 Copie de sauvegarde effectue : %s => %s", F_DIAL, F_DIAL_SAVE)
    Affichage::info("#70 Le fichier suivant a t mis  jour : %s", F_DIAL)
    
    Affichage::info("#16 Attention ! Le fichier dialogues a t modifi ! Continuez votre travail  partir de ce nouveau fichier ! \n%s", F_DIAL)

    pause if exe?
    
  end




  # ETAPE 4
  #
  # Transforme les maps dmk en maps RM
  def dmk_convert_to_rm(toutes=true)



    begin
      $project.compiler(toutes)
    rescue DMKW_DMK_Vide => e
      putss e.message
      raise(DMKW_Cancel.new)
    end



  end


  # ETAPE 5
  #
  # Cre un patch entre deux versions de dialogues
  #
  def creer_patch_dialogue



    putss "#44 Cration du patch de dialogues."

    # Cration du projet 1
    projet = Project_XP::projet_creer

    projet.etape_5
    
  
  end





  # ETAPE 6
  #
  # Cre toute une srie de statistiques sur le projet
  def creer_pourcentage_maker
    
    # Cration du projet
    projet = Project_XP::projet_creer

    begin
      projet.creer_pourcentage_maker
    rescue DMKW_DMK_Vide => e
      # Au cas o il n'y a ni maps ni BD
      Affichage::warning(e.message)
      raise(DMKW_Cancel.new)
    end

    
  end



  # ETAPE 7
  #
  # Redimensionne les dialogues
  def dmk_dialogs_resize

    # Cration du projet
    projet = Project_XP::projet_creer

    begin
      projet.redimensionner(*$options.resize_opt)
    rescue DMKW_Pol_No => e
      Affichage::warning(e.message)
      raise(DMKW_Cancel.new)
    end

  end



  # ETAPE 8
  #
  # Dtecte les ressources manquantes
  def detecter_ressource


    # Cration du projet
    projet = Project_XP::projet_creer

    rtp = $options.params_value("RTP")
    projet.add_rtp(rtp)
    

    #begin
    projet.detecter_ressource
    #rescue DMKW_Pol_No => e
    #  p e.message
    #  raise(DMKW_Cancel.new)
    #end


  end



  # 
  #
  # Mets les dialogues sur une seule ligne
  def mono_ligne

    # Cration du projet
    projet = Project_XP::projet_creer
    
    dial = projet.dossier_local(F_DIAL)
    projet.importer_dialogue(dial)
    projet.rassembler_instruction(projet.instructions)
    
    for instr in projet.instructions
      mess = instr[4]
      next if mess.is_a?(My_RPG::My_Command_Message) == false
      lignes = projet.red_une_ligne(mess.get_message)
      ligne = lignes.join(" ")
      mess.clear_suite
      mess.replace_texte(ligne)
    end

    projet.ecrire_dial("dialogues2.txt")


  end



  #
  #
  # Mets les dialogues sur une seule ligne
  def redim_max


    # Cration du projet
    projet = Project_XP::projet_creer

    dial = projet.dossier_local("dialogues3.txt")
    projet.importer_dialogue(dial)
    projet.rassembler_instruction(projet.instructions)

    max = 38

    for instr in projet.instructions#[0...1]
      mess = instr[4]
      next if mess.is_a?(My_RPG::My_Command_Message) == false
      lignes = projet.red_max_letter(mess.get_message, max)
      ligne = lignes.join("\n")
      p lignes if lignes.size > 4
      mess.clear_suite
      mess.replace_texte(ligne)
    end

    projet.ecrire_dial("dialogues4.txt")


  end


  # Option 9
  def dmk_go_website
    Launchy.open(DMK_WEBSITE)
  end


  
end